import { supabase, TABLES } from '@/config/supabase';
import { Reminder, ReminderType, ReminderStatus } from './types';

export const remindersService = {
  async createReminder({ vendor_id, customer_id, message, type, generated_by_ai, scheduled_at }: {
    vendor_id: string;
    customer_id: string;
    message: string;
    type: ReminderType;
    generated_by_ai: boolean;
    scheduled_at?: Date;
  }) {
    const { data, error } = await supabase
      .from('reminders')
      .insert([{
        vendor_id,
        customer_id,
        message,
        type,
        generated_by_ai,
        status: 'draft',
        scheduled_at: scheduled_at ? scheduled_at.toISOString() : null
      }])
      .select()
      .single();
    return { data, error };
  },

  async listReminders(vendor_id: string) {
    const { data, error } = await supabase
      .from('reminders')
      .select('*')
      .eq('vendor_id', vendor_id)
      .order('created_at', { ascending: false });
    return { data, error };
  },

  async getReminderById(id: string, vendor_id: string) {
    const { data, error } = await supabase
      .from('reminders')
      .select('*')
      .eq('id', id)
      .eq('vendor_id', vendor_id)
      .single();
    return { data, error };
  },

  async markReminderSent(id: string, vendor_id: string) {
    const { data, error } = await supabase
      .from('reminders')
      .update({ status: 'sent' })
      .eq('id', id)
      .eq('vendor_id', vendor_id)
      .select()
      .single();
    return { data, error };
  }
}; 